set scan off
Create or Replace Package Body CLEAN_Address_APP_AJAX
IS
gv_Package_Body_Version  CONSTANT VARCHAR2(30) := '3.5.0.0';
gv_Package_Body_Date     CONSTANT VARCHAR2(30) := '01-Apr-2008';
/*****************************************************************************************
 *
 *  Package Name    :   CLEAN_Address_APP_AJAX
 *
 *  Description     :   CLEAN_Address Application specific implementation procedures for
 *                      supporting AJAX calls from Web Self-Service Applications
 *
 *  Version         :   3.5.0.0 April 1, 2008
 *
 * ---------------------------------------------------------------------------------------
 *   Customer has the right to modify this package so long as original copyright remains
 * ---------------------------------------------------------------------------------------
 *
 *****************************************************************************************
 * Copyright (c) 2004-2008 Runner Technologies, Inc.  All Rights Reserved.
 * www.RunnerTechnologies.com   (877)784-0003  561-395-9322
 *****************************************************************************************/
-----------------------------------------------------------------------------------------
-- PUBLIC PROCEDURES
-----------------------------------------------------------------------------------------
--
-- FUNCTION CALL METHOD
--
/******************************************************************************************
 *  Procedure Name  :   f_Verify_Address_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as a function return value
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   ADDRESS1|ADDRESS2|ADDRESS3|ADDRESS4|CITY|STATE|POSTAL|COUNTY|COUNTRY|ADDRESS_ERROR_TEXT
 ******************************************************************************************/
FUNCTION f_Verify_Address_AJAX (
                     address_1                      IN     VARCHAR2 DEFAULT NULL
                    ,address_2                      IN     VARCHAR2 DEFAULT NULL
                    ,address_3                      IN     VARCHAR2 DEFAULT NULL
                    ,address_4                      IN     VARCHAR2 DEFAULT NULL
                    ,city                           IN     VARCHAR2 DEFAULT NULL
                    ,state                          IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,county_code                    IN     VARCHAR2 DEFAULT NULL
                    ,country_code                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_address_type                IN     VARCHAR2 DEFAULT NULL
                    ,company_name                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ) RETURN VARCHAR2
IS
  l_ADDRESS_rec         CLN_ADDRESSES%ROWTYPE;
  l_cln_address_rec   CLN_ADDRESS_APP%ROWTYPE;
  lv_address_error_text VARCHAR2(2000);
  lv_plsql_error        VARCHAR2(2000);
BEGIN
  --
  -- Assign the address record with parameters
  --
  l_ADDRESS_rec.COMPANY_NAME   := company_name;
  l_ADDRESS_rec.ADDRESS_LINE_1 := address_1;
  l_ADDRESS_rec.ADDRESS_LINE_2 := address_2;
  l_ADDRESS_rec.ADDRESS_LINE_3 := address_3;
  l_ADDRESS_rec.ADDRESS_LINE_4 := address_4;
  l_ADDRESS_rec.CITY           := city;
  l_ADDRESS_rec.STATE          := state;
  l_ADDRESS_rec.POSTAL_CODE    := postal_code;
  l_ADDRESS_rec.COUNTY_NAME    := county_code;
  l_ADDRESS_rec.COUNTRY_NAME   := country_code;
  --
  -- Verify the address
  --
  CLEAN_Address_APP.Verify_CLN_ADDRESSES_Record(
         f_ADDRESS_rec                 => l_ADDRESS_rec
        ,f_CLN_ADDRESS_APP_rec         => l_cln_address_rec
        ,address_error_text            => lv_address_error_text
        ,fv_plsql_error                => lv_plsql_error
        ,fv_address_type               => fv_address_type
        ,fv_company                    => company_name
        ,fv_object_name                => fv_object_name
        );
  if lv_address_error_text IS NOT NULL then
    lv_address_error_text := replace('Address Warning:<br>'||lv_address_error_text,chr(10),'<br>');
    if instr(lv_address_error_text, 'Suggestions:') = 0 then
      lv_address_error_text := '<b><font color=red>'||lv_address_error_text||'</font></b>';
    else
      lv_address_error_text := replace('<b><font color=red>'||lv_address_error_text, 'Suggestions:', '</font><br>Suggestions:</b><font color=blue>')||'</font>';
    end if;
  end if;
  return(
        rtrim(l_ADDRESS_rec.ADDRESS_LINE_1) ||'|'||
        rtrim(l_ADDRESS_rec.ADDRESS_LINE_2) ||'|'||
        rtrim(l_ADDRESS_rec.ADDRESS_LINE_3) ||'|'||
        rtrim(l_ADDRESS_rec.ADDRESS_LINE_4) ||'|'||
        rtrim(l_ADDRESS_rec.CITY) ||'|'||
        rtrim(l_ADDRESS_rec.STATE) ||'|'||
        rtrim(l_ADDRESS_rec.POSTAL_CODE) ||'|'||
        rtrim(l_ADDRESS_rec.COUNTY_NAME) ||'|'||
        rtrim(l_ADDRESS_rec.COUNTRY_NAME) ||'|'||
        rtrim(lv_address_error_text)
        );
END f_Verify_Address_AJAX;
/******************************************************************************************
 *  Procedure Name  :   f_Check_Telephone_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as a function return value
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   PHONE|EXT|SUGGESTED_AREA_CODE|DISTANCE|TELEPHONE_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
FUNCTION f_Check_Telephone_AJAX (
                     phone_area                     IN     VARCHAR2 DEFAULT NULL
                    ,phone_number                   IN     VARCHAR2 DEFAULT NULL
                    ,phone_extension                IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,fv_telephone_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ) RETURN VARCHAR2
IS
  l_PHONE_rec             CLN_ADDRESSES%ROWTYPE;
  lv_telephone_error_text VARCHAR2(2000);
  lv_plsql_error          VARCHAR2(2000);
  lv_suggested_area       VARCHAR2(10);
  lv_area                 VARCHAR2(10);
  ln_distance             NUMBER;
BEGIN
  --
  -- Assign the address record with parameters
  --
  lv_area                           := phone_area;
  l_PHONE_rec.TELEPHONE_1           := phone_number;
  l_PHONE_rec.TELEPHONE_1_EXTENSION := phone_extension;
  --
  -- Check the Telephone
  --
  --
  -- Call the CLEAN_Address Application Verify Telephone procedure with individual parameters
  --
  CLEAN_Address_APP.Check_Telephone (
           phone_area           => lv_area
          ,phone_number         => l_PHONE_rec.TELEPHONE_1
          ,phone_extension      => l_PHONE_rec.TELEPHONE_1_EXTENSION
          ,postal_code          => postal_code
          ,suggested_area       => lv_suggested_area
          ,distance             => ln_distance
          ,telephone_error_text => lv_telephone_error_text
          ,fv_plsql_error       => lv_plsql_error
          ,fv_telephone_code    => fv_telephone_code
          ,fv_object_name       => fv_object_name
          );
  if lv_telephone_error_text IS NOT NULL then
    lv_telephone_error_text := replace('Telephone Warning:<br>'||lv_telephone_error_text,chr(10),'<br>');
    lv_telephone_error_text := '<b><font color=red>'||lv_telephone_error_text||'</font></b>';
  end if;
  return(
        rtrim(l_PHONE_rec.TELEPHONE_1) ||'|'||
        rtrim(l_PHONE_rec.TELEPHONE_1_EXTENSION) ||'|'||
        rtrim(lv_suggested_area) ||'|'||
        rtrim(to_char(ln_distance)) ||'|'||
        rtrim(lv_telephone_error_text) ||'|'||
        rtrim(lv_plsql_error)
        );
END f_Check_Telephone_AJAX;
/******************************************************************************************
 *  Procedure Name  :   f_Standardize_Name_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as a function return value
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   FIRST|LAST|MIDDLE|PREFIX|SUFFIX|NAME_PARSE_STATUS_CODE|NAME_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
FUNCTION f_Standardize_Name_AJAX (
                     first_name                     IN     VARCHAR2 DEFAULT NULL
                    ,last_name                      IN     VARCHAR2 DEFAULT NULL
                    ,middle_name                    IN     VARCHAR2 DEFAULT NULL
                    ,prefix                         IN     VARCHAR2 DEFAULT NULL
                    ,suffix                         IN     VARCHAR2 DEFAULT NULL
                    ,fv_name_type_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ) RETURN VARCHAR2
IS
  l_name_rec           CLEAN_Address.NAME_REC;
  lv_name_error_text   VARCHAR2(200);
  lv_plsql_error       VARCHAR2(500);
BEGIN
  --
  -- Assign the input variables to the name record
  --
  l_name_rec.first_name      := first_name;
  l_name_rec.last_name       := last_name;
  l_name_rec.middle_name     := middle_name;
  l_name_rec.name_prefix     := prefix;
  l_name_rec.name_suffix     := suffix;
  --
  -- Standardize the Name
  --
  CLEAN_Address_APP.Standardize_Name_Record (
           f_name_rec          => l_name_rec
          ,fv_name_error_text  => lv_name_error_text
          ,fv_plsql_error      => lv_plsql_error
          ,fv_name_type_code   => fv_name_type_code
          ,fv_object_name      => fv_object_name
          );
  if lv_name_error_text IS NOT NULL then
    lv_name_error_text := replace('Name Warning:<br>'||lv_name_error_text,chr(10),'<br>');
    lv_name_error_text := '<b><font color=red>'||lv_name_error_text||'</font></b>';
  end if;
  return(
        rtrim(l_name_rec.first_name) ||'|'||
        rtrim(l_name_rec.last_name) ||'|'||
        rtrim(l_name_rec.middle_name) ||'|'||
        rtrim(l_name_rec.name_prefix) ||'|'||
        rtrim(l_name_rec.name_suffix) ||'|'||
        rtrim(l_name_rec.name_parse_status_code) ||'|'||
        rtrim(lv_name_error_text) ||'|'||
        rtrim(lv_plsql_error)
        );
END f_Standardize_Name_AJAX;
/******************************************************************************************
 *  Procedure Name  :   f_Validate_Email_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as a function return value
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   EMAIL|EMAIL_STATUS_CODE|EMAIL_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
FUNCTION f_Validate_Email_AJAX (
                     email_address                  IN     VARCHAR2 DEFAULT NULL
                    ,fv_email_type_code             IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ) RETURN VARCHAR2
IS
  l_email_rec          CLEAN_Address.EMAIL_REC;
  lv_email_error_text  VARCHAR2(200);
  lv_plsql_error       VARCHAR2(500);
BEGIN
  --
  -- Assign the input variables to the email record
  --
  l_email_rec.email_address := email_address;
  --
  -- Validate the Email
  --
  CLEAN_Address_APP.Validate_Email_Record (
           f_email_rec         => l_email_rec
          ,fv_email_error_text => lv_email_error_text
          ,fv_plsql_error      => lv_plsql_error
          ,fv_email_type_code  => fv_email_type_code
          ,fv_object_name      => fv_object_name
          );
  if lv_email_error_text IS NOT NULL then
    lv_email_error_text := replace('Email Warning:<br>'||lv_email_error_text,chr(10),'<br>');
    lv_email_error_text := '<b><font color=red>'||lv_email_error_text||'</font></b>';
  end if;
  return(
        rtrim(l_email_rec.email_address) ||'|'||
        rtrim(l_email_rec.email_status_code) ||'|'||
        rtrim(lv_email_error_text) ||'|'||
        rtrim(lv_plsql_error)
        );
END f_Validate_Email_AJAX;
--
-- PROCEDURE RETURN VALUE METHOD
--
/******************************************************************************************
 *  Procedure Name  :   p_Verify_Address_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as return value in OUT parameter
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   ADDRESS1|ADDRESS2|ADDRESS3|ADDRESS4|CITY|STATE|POSTAL|COUNTY|COUNTRY|ADDRESS_ERROR_TEXT
 ******************************************************************************************/
PROCEDURE p_Verify_Address_AJAX (
                     address_1                      IN     VARCHAR2 DEFAULT NULL
                    ,address_2                      IN     VARCHAR2 DEFAULT NULL
                    ,address_3                      IN     VARCHAR2 DEFAULT NULL
                    ,address_4                      IN     VARCHAR2 DEFAULT NULL
                    ,city                           IN     VARCHAR2 DEFAULT NULL
                    ,state                          IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,county_code                    IN     VARCHAR2 DEFAULT NULL
                    ,country_code                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_address_type                IN     VARCHAR2 DEFAULT NULL
                    ,company_name                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ,fv_response                       OUT VARCHAR2
                    )
IS
BEGIN
  fv_response := f_Verify_Address_AJAX (
                     address_1       => address_1
                    ,address_2       => address_2
                    ,address_3       => address_3
                    ,address_4       => address_4
                    ,city            => city
                    ,state           => state
                    ,postal_code     => postal_code
                    ,county_code     => county_code
                    ,country_code    => country_code
                    ,fv_address_type => fv_address_type
                    ,company_name    => company_name
                    ,fv_object_name  => fv_object_name
                    );
END p_Verify_Address_AJAX;
/******************************************************************************************
 *  Procedure Name  :   p_Check_Telephone_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as return value in OUT parameter
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   PHONE|EXT|SUGGESTED_AREA_CODE|DISTANCE|TELEPHONE_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE p_Check_Telephone_AJAX (
                     phone_area                     IN     VARCHAR2 DEFAULT NULL
                    ,phone_number                   IN     VARCHAR2 DEFAULT NULL
                    ,phone_extension                IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,fv_telephone_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ,fv_response                       OUT VARCHAR2
                    )
IS
BEGIN
  fv_response := f_Check_Telephone_AJAX (
                     phone_area        => phone_area
                    ,phone_number      => phone_number
                    ,phone_extension   => phone_extension
                    ,postal_code       => postal_code
                    ,fv_telephone_code => fv_telephone_code
                    ,fv_object_name    => fv_object_name
                    );
END p_Check_Telephone_AJAX;
/******************************************************************************************
 *  Procedure Name  :   p_Standardize_Name_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as return value in OUT parameter
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   FIRST|LAST|MIDDLE|PREFIX|SUFFIX|NAME_PARSE_STATUS_CODE|NAME_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE p_Standardize_Name_AJAX (
                     first_name                     IN     VARCHAR2 DEFAULT NULL
                    ,last_name                      IN     VARCHAR2 DEFAULT NULL
                    ,middle_name                    IN     VARCHAR2 DEFAULT NULL
                    ,prefix                         IN     VARCHAR2 DEFAULT NULL
                    ,suffix                         IN     VARCHAR2 DEFAULT NULL
                    ,fv_name_type_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ,fv_response                       OUT VARCHAR2
                    )
IS
BEGIN
  fv_response := f_Standardize_Name_AJAX (
                     first_name        => first_name
                    ,last_name         => last_name
                    ,middle_name       => middle_name
                    ,prefix            => prefix
                    ,suffix            => suffix
                    ,fv_name_type_code => fv_name_type_code
                    ,fv_object_name    => fv_object_name
                    );
END p_Standardize_Name_AJAX;
/******************************************************************************************
 *  Procedure Name  :   p_Validate_Email_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String as return value in OUT parameter
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   EMAIL|EMAIL_STATUS_CODE|EMAIL_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE p_Validate_Email_AJAX (
                     email_address                  IN     VARCHAR2 DEFAULT NULL
                    ,fv_email_type_code             IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    ,fv_response                       OUT VARCHAR2
                    )
IS
BEGIN
  fv_response := f_Validate_Email_AJAX (
                     email_address      => email_address
                    ,fv_email_type_code => fv_email_type_code
                    ,fv_object_name     => fv_object_name
                    );
END p_Validate_Email_AJAX;
--
-- HTTP MOD_PLSQL TOOLKIT CALL METHOD
--
/******************************************************************************************
 *  Procedure Name  :   Verify_Address_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String in HTTP format using mod_plsql toolkit
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   ADDRESS1|ADDRESS2|ADDRESS3|ADDRESS4|CITY|STATE|POSTAL|COUNTY|COUNTRY|ADDRESS_ERROR_TEXT
 ******************************************************************************************/
PROCEDURE Verify_Address_AJAX (
                     address_1                      IN     VARCHAR2 DEFAULT NULL
                    ,address_2                      IN     VARCHAR2 DEFAULT NULL
                    ,address_3                      IN     VARCHAR2 DEFAULT NULL
                    ,address_4                      IN     VARCHAR2 DEFAULT NULL
                    ,city                           IN     VARCHAR2 DEFAULT NULL
                    ,state                          IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,county_code                    IN     VARCHAR2 DEFAULT NULL
                    ,country_code                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_address_type                IN     VARCHAR2 DEFAULT NULL
                    ,company_name                   IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    )
IS
BEGIN
  htp.p(f_Verify_Address_AJAX (
                     address_1       => address_1
                    ,address_2       => address_2
                    ,address_3       => address_3
                    ,address_4       => address_4
                    ,city            => city
                    ,state           => state
                    ,postal_code     => postal_code
                    ,county_code     => county_code
                    ,country_code    => country_code
                    ,fv_address_type => fv_address_type
                    ,company_name    => company_name
                    ,fv_object_name  => fv_object_name
                    ));
END Verify_Address_AJAX;
/******************************************************************************************
 *  Procedure Name  :   Check_Telephone_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String in HTTP format using mod_plsql toolkit
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   PHONE|EXT|SUGGESTED_AREA_CODE|DISTANCE|TELEPHONE_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE Check_Telephone_AJAX (
                     phone_area                     IN     VARCHAR2 DEFAULT NULL
                    ,phone_number                   IN     VARCHAR2 DEFAULT NULL
                    ,phone_extension                IN     VARCHAR2 DEFAULT NULL
                    ,postal_code                    IN     VARCHAR2 DEFAULT NULL
                    ,fv_telephone_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    )
IS
BEGIN
  htp.p(f_Check_Telephone_AJAX (
                     phone_area        => phone_area
                    ,phone_number      => phone_number
                    ,phone_extension   => phone_extension
                    ,postal_code       => postal_code
                    ,fv_telephone_code => fv_telephone_code
                    ,fv_object_name    => fv_object_name
                    ));
END Check_Telephone_AJAX;
/******************************************************************************************
 *  Procedure Name  :   Standardize_Name_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String in HTTP format using mod_plsql toolkit
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   FIRST|LAST|MIDDLE|PREFIX|SUFFIX|NAME_PARSE_STATUS_CODE|NAME_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE Standardize_Name_AJAX (
                     first_name                     IN     VARCHAR2 DEFAULT NULL
                    ,last_name                      IN     VARCHAR2 DEFAULT NULL
                    ,middle_name                    IN     VARCHAR2 DEFAULT NULL
                    ,prefix                         IN     VARCHAR2 DEFAULT NULL
                    ,suffix                         IN     VARCHAR2 DEFAULT NULL
                    ,fv_name_type_code              IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    )
IS
BEGIN
  htp.p(f_Standardize_Name_AJAX (
                     first_name        => first_name
                    ,last_name         => last_name
                    ,middle_name       => middle_name
                    ,prefix            => prefix
                    ,suffix            => suffix
                    ,fv_name_type_code => fv_name_type_code
                    ,fv_object_name    => fv_object_name
                    ));
END Standardize_Name_AJAX;
/******************************************************************************************
 *  Procedure Name  :   Validate_Email_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String in HTTP format using mod_plsql toolkit
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   EMAIL|EMAIL_STATUS_CODE|EMAIL_ERROR_TEXT|PLSQL_ERROR
 ******************************************************************************************/
PROCEDURE Validate_Email_AJAX (
                     email_address                  IN     VARCHAR2 DEFAULT NULL
                    ,fv_email_type_code             IN     VARCHAR2 DEFAULT NULL
                    ,fv_object_name                 IN     VARCHAR2 DEFAULT NULL /* Object Name where procedure is called from */
                    )
IS
BEGIN
  htp.p(f_Validate_Email_AJAX (
                     email_address      => email_address
                    ,fv_email_type_code => fv_email_type_code
                    ,fv_object_name     => fv_object_name
                    ));
END Validate_Email_AJAX;
END CLEAN_Address_APP_AJAX;

/

set scan on
